// Sample reports data (you can replace or extend it)
const reportsData = [
  {
    title: "Malkia Wa Nguvu Report 2024",
    year: "2024",
    description:
      "A comprehensive overview of our programs, achievements, and financial performance for the year.",
    pdf: "#",
    image: "https://malkiawanguvu.co.tz/wp-content/uploads/2025/12/1111223344.jpg"
  },
  {
    title: "Maarifa Camp Report 2024",
    year: "2024",
    description:
      "Insights into our second quarter activities, partnerships, and community impact.",
    pdf: "#",
    image: "https://malkiawanguvu.co.tz/wp-content/uploads/2025/12/12345.jpg"
  },
  {
    title: "Tuyajenge Talks Report 2024",
    year: "2024",
    description:
      "Evaluation of long-term outcomes and sustainability of our initiatives.",
    pdf: "#",
    image: "https://malkiawanguvu.co.tz/wp-content/uploads/2025/12/1111223344.jpg"
  },
  {
    title: "Annual Report 2022",
    year: "2022",
    description:
      "A detailed report on the year's activities, financials, and milestones.",
    pdf: "#",
    image: "https://via.placeholder.com/800x400/8e44ad/fff?text=Annual+Report+2022"
  },
  {
    title: "Quarter Three Report 2024",
    year: "2024",
    description:
      "Our quarterly updates on community outreach, new projects, and partnerships.",
    pdf: "#",
    image: "https://via.placeholder.com/800x400/7a1fa2/fff?text=Quarter+Three+Report+2024"
  },
  {
    title: "Impact Review Report 2023",
    year: "2023",
    description:
      "A comprehensive review of the impact we’ve had in the communities we serve.",
    pdf: "#",
    image: "https://via.placeholder.com/800x400/5e1680/fff?text=Impact+Review+Report+2023"
  }
];

let currentIndex = 0;
const reportsPerLoad = 3;

const container = document.getElementById("reportsContainer");
const loadMoreBtn = document.getElementById("loadMoreBtn");
const imageModal = new bootstrap.Modal(document.getElementById("imageModal"));
const modalImage = document.getElementById("modalImage");

// Function to render reports
function renderReports() {
  for (let i = currentIndex; i < currentIndex + reportsPerLoad && i < reportsData.length; i++) {
    const report = reportsData[i];

    const col = document.createElement("div");
    col.className = "col-lg-4 col-md-6 col-sm-12 mb-4";

    const card = document.createElement("div");
    card.className = "report-card";

    card.innerHTML = `
      <img src="${report.image}" alt="${report.title}" class="card-img-top" onclick="viewImage('${report.image}')"/>
      <div class="card-body">
        <h3 class="card-title">${report.title}</h3>
        <div class="year">${report.year}</div>
        <p class="card-text">${report.description}</p>
        <a href="${report.pdf}" class="btn btn-primary" target="_blank">Download PDF</a>
      </div>
    `;

    col.appendChild(card);
    container.appendChild(col);
  }

  currentIndex += reportsPerLoad;

  if (currentIndex >= reportsData.length) {
    loadMoreBtn.style.display = "none"; // Hide the button if no more reports to load
  }
}

// Function to view image in modal
function viewImage(imageSrc) {
  modalImage.src = imageSrc;
  imageModal.show();
}

// Initial load
renderReports();

// Load more reports when the button is clicked
loadMoreBtn.addEventListener("click", renderReports);
